<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * EmpresaUnidade Model
 *
 * @method \App\Model\Entity\EmpresaUnidade get($primaryKey, $options = [])
 * @method \App\Model\Entity\EmpresaUnidade newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\EmpresaUnidade[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaUnidade|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\EmpresaUnidade patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaUnidade[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\EmpresaUnidade findOrCreate($search, callable $callback = null, $options = [])
 */
class EmpresaUnidadeTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('empresa_unidade');
        $this->setDisplayField('idempresa');
        $this->setPrimaryKey('idempresa');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa', 'create');

        $validator
            ->scalar('coderp')
            ->maxLength('coderp', 20)
            ->allowEmpty('coderp');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 70)
            ->allowEmpty('nome');

        $validator
            ->scalar('razaosocial')
            ->maxLength('razaosocial', 70)
            ->allowEmpty('razaosocial');

        $validator
            ->scalar('logo')
            ->maxLength('logo', 255)
            ->allowEmpty('logo');

        $validator
            ->scalar('cnpj')
            ->maxLength('cnpj', 20)
            ->allowEmpty('cnpj');

        $validator
            ->scalar('cidade')
            ->maxLength('cidade', 70)
            ->allowEmpty('cidade');

        $validator
            ->scalar('estado')
            ->maxLength('estado', 2)
            ->allowEmpty('estado');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
