<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Empresacarteira Model
 *
 * @method \App\Model\Entity\Empresacarteira get($primaryKey, $options = [])
 * @method \App\Model\Entity\Empresacarteira newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Empresacarteira[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Empresacarteira|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Empresacarteira patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Empresacarteira[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Empresacarteira findOrCreate($search, callable $callback = null, $options = [])
 */
class EmpresacarteiraTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('empresacarteira');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('cod_unimed')
            ->allowEmpty('cod_unimed');

        $validator
            ->integer('cod_empresa')
            ->allowEmpty('cod_empresa');

        $validator
            ->scalar('razao_social')
            ->maxLength('razao_social', 300)
            ->allowEmpty('razao_social');

        $validator
            ->scalar('cgc_empresa')
            ->maxLength('cgc_empresa', 30)
            ->allowEmpty('cgc_empresa');

        $validator
            ->scalar('incl_empresa')
            ->maxLength('incl_empresa', 20)
            ->allowEmpty('incl_empresa');

        $validator
            ->scalar('exc_empresa')
            ->maxLength('exc_empresa', 20)
            ->allowEmpty('exc_empresa');

        $validator
            ->integer('cod_contrato')
            ->allowEmpty('cod_contrato');

        $validator
            ->scalar('incl_contrato')
            ->maxLength('incl_contrato', 20)
            ->allowEmpty('incl_contrato');

        $validator
            ->scalar('exc_contrato')
            ->maxLength('exc_contrato', 20)
            ->allowEmpty('exc_contrato');

        return $validator;
    }
}
