<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Empresaobs Model
 *
 * @method \App\Model\Entity\Empresaob get($primaryKey, $options = [])
 * @method \App\Model\Entity\Empresaob newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Empresaob[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Empresaob|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Empresaob patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Empresaob[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Empresaob findOrCreate($search, callable $callback = null, $options = [])
 */
class EmpresaobsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('empresaobs');
        $this->setDisplayField('empresaobsid');
        $this->setPrimaryKey('empresaobsid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('empresaobsid')
            ->allowEmpty('empresaobsid', 'create');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 8000)
            ->allowEmpty('observacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
