<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Empresaproduto Model
 *
 * @method \App\Model\Entity\Empresaproduto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Empresaproduto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Empresaproduto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Empresaproduto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Empresaproduto|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Empresaproduto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Empresaproduto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Empresaproduto findOrCreate($search, callable $callback = null, $options = [])
 */
class EmpresaprodutoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('empresaproduto');
        $this->setDisplayField('empresaprodutoid');
        $this->setPrimaryKey('empresaprodutoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('empresaprodutoid')
            ->allowEmpty('empresaprodutoid', 'create');

        $validator
            ->integer('empresaid')
            ->requirePresence('empresaid', 'create')
            ->notEmpty('empresaid');

        $validator
            ->integer('regraprodutoid')
            ->requirePresence('regraprodutoid', 'create')
            ->notEmpty('regraprodutoid');

        $validator
            ->integer('produtoid')
            ->requirePresence('produtoid', 'create')
            ->notEmpty('produtoid');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        return $validator;
    }
}
