<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Endereco Model
 *
 * @method \App\Model\Entity\Endereco get($primaryKey, $options = [])
 * @method \App\Model\Entity\Endereco newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Endereco[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Endereco|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Endereco patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Endereco[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Endereco findOrCreate($search, callable $callback = null, $options = [])
 */
class EnderecoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('endereco');
        $this->setDisplayField('enderecoid');
        $this->setPrimaryKey('enderecoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('enderecoid')
            ->allowEmpty('enderecoid', 'create');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->scalar('logradouro')
            ->maxLength('logradouro', 255)
            ->allowEmpty('logradouro');

        $validator
            ->scalar('cidade')
            ->maxLength('cidade', 255)
            ->allowEmpty('cidade');

        $validator
            ->scalar('estado')
            ->maxLength('estado', 255)
            ->allowEmpty('estado');

        $validator
            ->scalar('pais')
            ->maxLength('pais', 255)
            ->allowEmpty('pais');

        $validator
            ->scalar('bairro')
            ->maxLength('bairro', 255)
            ->allowEmpty('bairro');

        $validator
            ->scalar('codibge')
            ->maxLength('codibge', 20)
            ->allowEmpty('codibge');

        $validator
            ->scalar('numero')
            ->maxLength('numero', 20)
            ->allowEmpty('numero');

        $validator
            ->scalar('complemento')
            ->maxLength('complemento', 255)
            ->allowEmpty('complemento');

        $validator
            ->scalar('tipoendereco')
            ->maxLength('tipoendereco', 255)
            ->allowEmpty('tipoendereco');

        $validator
            ->scalar('cep')
            ->maxLength('cep', 20)
            ->allowEmpty('cep');

        $validator
            ->scalar('observacoes')
            ->maxLength('observacoes', 500)
            ->allowEmpty('observacoes');

        $validator
            ->scalar('latlong')
            ->maxLength('latlong', 255)
            ->allowEmpty('latlong');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
