<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Entradapacientes Model
 *
 * @method \App\Model\Entity\Entradapaciente get($primaryKey, $options = [])
 * @method \App\Model\Entity\Entradapaciente newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Entradapaciente[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Entradapaciente|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Entradapaciente patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Entradapaciente[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Entradapaciente findOrCreate($search, callable $callback = null, $options = [])
 */
class EntradapacientesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('entradapacientes');
        $this->setDisplayField('entradapacientesid');
        $this->setPrimaryKey('entradapacientesid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('entradapacientesid')
            ->allowEmpty('entradapacientesid', 'create');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 20)
            ->allowEmpty('tipo');

        $validator
            ->scalar('sexo')
            ->maxLength('sexo', 20)
            ->allowEmpty('sexo');

        $validator
            ->integer('idade')
            ->allowEmpty('idade');

        $validator
            ->scalar('gruporisco')
            ->maxLength('gruporisco', 50)
            ->allowEmpty('gruporisco');

        $validator
            ->integer('qtdpessoas')
            ->allowEmpty('qtdpessoas');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 800)
            ->allowEmpty('observacao');

        $validator
            ->integer('usuariocadastro')
            ->allowEmpty('usuariocadastro');

        $validator
            ->scalar('usuariocadastronome')
            ->maxLength('usuariocadastronome', 255)
            ->allowEmpty('usuariocadastronome');

        $validator
            ->dateTime('datacadastro')
            ->allowEmpty('datacadastro');

        $validator
            ->integer('codunimed')
            ->requirePresence('codunimed', 'create')
            ->notEmpty('codunimed');

        $validator
            ->scalar('carteiracpf')
            ->maxLength('carteiracpf', 50)
            ->allowEmpty('carteiracpf');

        $validator
            ->scalar('data_nascimento')
            ->allowEmpty('data_nascimento');

        $validator
            ->scalar('local')
            ->maxLength('local', 50)
            ->allowEmpty('local');

        $validator
            ->integer('hospitalid')
            ->allowEmpty('hospitalid');

        $validator
            ->boolean('testecolhido')
            ->requirePresence('testecolhido', 'create')
            ->notEmpty('testecolhido');

        $validator
            ->boolean('ventilacao')
            ->requirePresence('ventilacao', 'create')
            ->notEmpty('ventilacao');

        $validator
            ->boolean('alta')
            ->requirePresence('alta', 'create')
            ->notEmpty('alta');

        $validator
            ->dateTime('dataalta')
            ->allowEmpty('dataalta');

        $validator
            ->scalar('codigoteste')
            ->maxLength('codigoteste', 50)
            ->allowEmpty('codigoteste');

        $validator
            ->scalar('ultimotratamento')
            ->maxLength('ultimotratamento', 50)
            ->allowEmpty('ultimotratamento');

        $validator
            ->date('data_ultimotratamento')
            ->allowEmpty('data_ultimotratamento');

        $validator
            ->boolean('obito')
            ->allowEmpty('obito');

        $validator
            ->dateTime('dataobito')
            ->allowEmpty('dataobito');

        $validator
            ->integer('prontuarioatendimentoid')
            ->requirePresence('prontuarioatendimentoid', 'create')
            ->notEmpty('prontuarioatendimentoid');

        $validator
            ->boolean('auditado')
            ->requirePresence('auditado', 'create')
            ->notEmpty('auditado');

        $validator
            ->scalar('tiposuporte')
            ->maxLength('tiposuporte', 50)
            ->allowEmpty('tiposuporte');

        $validator
            ->scalar('descricaosuporte')
            ->maxLength('descricaosuporte', 255)
            ->allowEmpty('descricaosuporte');

        $validator
            ->boolean('antibiotico')
            ->requirePresence('antibiotico', 'create')
            ->notEmpty('antibiotico');

        $validator
            ->scalar('antibioticonome')
            ->maxLength('antibioticonome', 255)
            ->allowEmpty('antibioticonome');

        $validator
            ->boolean('parecer')
            ->requirePresence('parecer', 'create')
            ->notEmpty('parecer');

        $validator
            ->scalar('especialidademedica')
            ->maxLength('especialidademedica', 255)
            ->allowEmpty('especialidademedica');

        $validator
            ->boolean('hemodialise')
            ->requirePresence('hemodialise', 'create')
            ->notEmpty('hemodialise');

        $validator
            ->boolean('imunobiologicos')
            ->requirePresence('imunobiologicos', 'create')
            ->notEmpty('imunobiologicos');

        $validator
            ->date('datacoleta')
            ->allowEmpty('datacoleta');

        $validator
            ->scalar('imunobiologicosnome')
            ->maxLength('imunobiologicosnome', 255)
            ->allowEmpty('imunobiologicosnome');

        return $validator;
    }
}
