<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Erp Model
 *
 * @method \App\Model\Entity\Erp get($primaryKey, $options = [])
 * @method \App\Model\Entity\Erp newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Erp[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Erp|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Erp patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Erp[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Erp findOrCreate($search, callable $callback = null, $options = [])
 */
class ErpTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('erp');
        $this->setDisplayField('iderp');
        $this->setPrimaryKey('iderp');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('iderp')
            ->allowEmpty('iderp', 'create');

        $validator
            ->scalar('chave')
            ->maxLength('chave', 255)
            ->allowEmpty('chave');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('responsavel')
            ->maxLength('responsavel', 255)
            ->allowEmpty('responsavel');

        $validator
            ->scalar('telefone')
            ->maxLength('telefone', 255)
            ->allowEmpty('telefone');

        $validator
            ->email('email')
            ->allowEmpty('email');

        $validator
            ->scalar('endereco')
            ->maxLength('endereco', 255)
            ->allowEmpty('endereco');

        $validator
            ->scalar('logo')
            ->maxLength('logo', 255)
            ->allowEmpty('logo');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['email']));

        return $rules;
    }
}
