<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Estipulante Model
 *
 * @method \App\Model\Entity\Estipulante get($primaryKey, $options = [])
 * @method \App\Model\Entity\Estipulante newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Estipulante[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Estipulante|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Estipulante|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Estipulante patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Estipulante[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Estipulante findOrCreate($search, callable $callback = null, $options = [])
 */
class EstipulanteTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('estipulante');
        $this->setDisplayField('estipulanteid');
        $this->setPrimaryKey('estipulanteid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('estipulanteid')
            ->allowEmpty('estipulanteid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 250)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 250)
            ->allowEmpty('descricao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('logo')
            ->maxLength('logo', 500)
            ->allowEmpty('logo');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        return $validator;
    }
}
