<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Eventolista Model
 *
 * @method \App\Model\Entity\Eventolistum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Eventolistum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Eventolistum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Eventolistum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Eventolistum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Eventolistum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Eventolistum findOrCreate($search, callable $callback = null, $options = [])
 */
class EventolistaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('eventolista');
        $this->setDisplayField('eventolistaid');
        $this->setPrimaryKey('eventolistaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('eventolistaid')
            ->allowEmpty('eventolistaid', 'create');

        $validator
            ->integer('eventoid')
            ->allowEmpty('eventoid');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('responsavel')
            ->maxLength('responsavel', 255)
            ->allowEmpty('responsavel');

        $validator
            ->dateTime('datahora_inicio')
            ->allowEmpty('datahora_inicio');

        $validator
            ->dateTime('datahora_fim')
            ->allowEmpty('datahora_fim');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->integer('usuario_criacao')
            ->allowEmpty('usuario_criacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
