<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Eventopessoa Model
 *
 * @method \App\Model\Entity\Eventopessoa get($primaryKey, $options = [])
 * @method \App\Model\Entity\Eventopessoa newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Eventopessoa[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Eventopessoa|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Eventopessoa patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Eventopessoa[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Eventopessoa findOrCreate($search, callable $callback = null, $options = [])
 */
class EventopessoaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('eventopessoa');
        $this->setDisplayField('eventopessoaid');
        $this->setPrimaryKey('eventopessoaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('eventopessoaid')
            ->allowEmpty('eventopessoaid', 'create');

        $validator
            ->integer('eventoid')
            ->allowEmpty('eventoid');

        $validator
            ->integer('eventolistaid')
            ->allowEmpty('eventolistaid');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('documento')
            ->maxLength('documento', 50)
            ->allowEmpty('documento');

        $validator
            ->scalar('telefone')
            ->maxLength('telefone', 50)
            ->allowEmpty('telefone');

        $validator
            ->scalar('voucher')
            ->maxLength('voucher', 255)
            ->allowEmpty('voucher');

        $validator
            ->scalar('sexo')
            ->maxLength('sexo', 50)
            ->allowEmpty('sexo');

        $validator
            ->scalar('data_nascimento')
            ->maxLength('data_nascimento', 20)
            ->allowEmpty('data_nascimento');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->integer('data_entrada')
            ->allowEmpty('data_entrada');

        $validator
            ->integer('data_saida')
            ->allowEmpty('data_saida');

        $validator
            ->integer('usuario_criacao')
            ->allowEmpty('usuario_criacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
