<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Faleconosco Model
 *
 * @method \App\Model\Entity\Faleconosco get($primaryKey, $options = [])
 * @method \App\Model\Entity\Faleconosco newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Faleconosco[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Faleconosco|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Faleconosco patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Faleconosco[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Faleconosco findOrCreate($search, callable $callback = null, $options = [])
 */
class FaleconoscoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('faleconosco');
        $this->setDisplayField('idfaleconosco');
        $this->setPrimaryKey('idfaleconosco');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idfaleconosco')
            ->allowEmpty('idfaleconosco', 'create');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->dateTime('data_mensagem')
            ->allowEmpty('data_mensagem');

        $validator
            ->scalar('mensagem')
            ->maxLength('mensagem', 8000)
            ->allowEmpty('mensagem');

        $validator
            ->integer('status')
            ->allowEmpty('status');

        $validator
            ->scalar('feedback')
            ->maxLength('feedback', 8000)
            ->allowEmpty('feedback');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('idusuariofeedback')
            ->allowEmpty('idusuariofeedback');

        $validator
            ->dateTime('data_feedback')
            ->allowEmpty('data_feedback');

        return $validator;
    }
}
