<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Flyleads Model
 *
 * @method \App\Model\Entity\Flylead get($primaryKey, $options = [])
 * @method \App\Model\Entity\Flylead newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Flylead[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Flylead|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Flylead patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Flylead[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Flylead findOrCreate($search, callable $callback = null, $options = [])
 */
class FlyleadsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('flyleads');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->scalar('cnpj')
            ->maxLength('cnpj', 20)
            ->allowEmpty('cnpj');

        $validator
            ->scalar('razaosocial')
            ->maxLength('razaosocial', 500)
            ->allowEmpty('razaosocial');

        $validator
            ->scalar('nomefantasia')
            ->maxLength('nomefantasia', 500)
            ->allowEmpty('nomefantasia');

        $validator
            ->scalar('porte')
            ->maxLength('porte', 100)
            ->allowEmpty('porte');

        $validator
            ->scalar('cidade')
            ->maxLength('cidade', 200)
            ->allowEmpty('cidade');

        $validator
            ->scalar('estado')
            ->maxLength('estado', 50)
            ->allowEmpty('estado');

        $validator
            ->scalar('logradouro')
            ->maxLength('logradouro', 500)
            ->allowEmpty('logradouro');

        $validator
            ->scalar('nomecnae')
            ->maxLength('nomecnae', 200)
            ->allowEmpty('nomecnae');

        $validator
            ->scalar('codsetor')
            ->maxLength('codsetor', 20)
            ->allowEmpty('codsetor');

        $validator
            ->scalar('nomesetor')
            ->maxLength('nomesetor', 200)
            ->allowEmpty('nomesetor');

        $validator
            ->scalar('telefone')
            ->maxLength('telefone', 50)
            ->allowEmpty('telefone');

        $validator
            ->email('email')
            ->allowEmpty('email');

        $validator
            ->scalar('cod_secao')
            ->maxLength('cod_secao', 50)
            ->allowEmpty('cod_secao');

        $validator
            ->scalar('nm_secao')
            ->maxLength('nm_secao', 255)
            ->allowEmpty('nm_secao');

        $validator
            ->scalar('cod_divisao')
            ->maxLength('cod_divisao', 50)
            ->allowEmpty('cod_divisao');

        $validator
            ->scalar('nm_divisao')
            ->maxLength('nm_divisao', 255)
            ->allowEmpty('nm_divisao');

        $validator
            ->scalar('cod_grupo')
            ->maxLength('cod_grupo', 50)
            ->allowEmpty('cod_grupo');

        $validator
            ->scalar('nm_grupo')
            ->maxLength('nm_grupo', 255)
            ->allowEmpty('nm_grupo');

        $validator
            ->scalar('cod_classe')
            ->maxLength('cod_classe', 50)
            ->allowEmpty('cod_classe');

        $validator
            ->scalar('nm_classe')
            ->maxLength('nm_classe', 255)
            ->allowEmpty('nm_classe');

        $validator
            ->scalar('cod_cnae')
            ->maxLength('cod_cnae', 50)
            ->allowEmpty('cod_cnae');

        $validator
            ->scalar('nm_cnae')
            ->maxLength('nm_cnae', 255)
            ->allowEmpty('nm_cnae');

        $validator
            ->scalar('impacto')
            ->maxLength('impacto', 255)
            ->allowEmpty('impacto');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['email']));

        return $rules;
    }
}
