<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Formapag Model
 *
 * @property \App\Model\Table\CondpagTable|\Cake\ORM\Association\BelongsToMany $Condpag
 *
 * @method \App\Model\Entity\Formapag get($primaryKey, $options = [])
 * @method \App\Model\Entity\Formapag newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Formapag[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Formapag|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Formapag patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Formapag[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Formapag findOrCreate($search, callable $callback = null, $options = [])
 */
class FormapagTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('formapag');
        $this->setDisplayField('formapagid');
        $this->setPrimaryKey('formapagid');

        $this->belongsToMany('Condpag', [
            'foreignKey' => 'formapag_id',
            'targetForeignKey' => 'condpag_id',
            'joinTable' => 'formapag_condpag'
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('formapagid')
            ->allowEmpty('formapagid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 20)
            ->allowEmpty('nome');

        $validator
            ->integer('ordem')
            ->allowEmpty('ordem');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
