<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Fototipo Model
 *
 * @method \App\Model\Entity\Fototipo get($primaryKey, $options = [])
 * @method \App\Model\Entity\Fototipo newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Fototipo[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Fototipo|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Fototipo patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Fototipo[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Fototipo findOrCreate($search, callable $callback = null, $options = [])
 */
class FototipoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('fototipo');
        $this->setDisplayField('idfototipo');
        $this->setPrimaryKey('idfototipo');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idfototipo')
            ->allowEmpty('idfototipo', 'create');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        return $validator;
    }
}
