<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Funil Model
 *
 * @method \App\Model\Entity\Funil get($primaryKey, $options = [])
 * @method \App\Model\Entity\Funil newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Funil[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Funil|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Funil patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Funil[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Funil findOrCreate($search, callable $callback = null, $options = [])
 */
class FunilTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('funil');
        $this->setDisplayField('idfunil');
        $this->setPrimaryKey('idfunil');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idfunil')
            ->allowEmpty('idfunil', 'create');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->integer('lead')
            ->allowEmpty('lead');

        return $validator;
    }
}
