<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Grauinteressecontato Model
 *
 * @method \App\Model\Entity\Grauinteressecontato get($primaryKey, $options = [])
 * @method \App\Model\Entity\Grauinteressecontato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Grauinteressecontato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Grauinteressecontato|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Grauinteressecontato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Grauinteressecontato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Grauinteressecontato findOrCreate($search, callable $callback = null, $options = [])
 */
class GrauinteressecontatoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('grauinteressecontato');
        $this->setDisplayField('grauinteressecontatoid');
        $this->setPrimaryKey('grauinteressecontatoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('grauinteressecontatoid')
            ->allowEmpty('grauinteressecontatoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('peso')
            ->allowEmpty('peso');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('cor')
            ->maxLength('cor', 20)
            ->allowEmpty('cor');

        return $validator;
    }
}
