<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Grupocomissaoregra Model
 *
 * @method \App\Model\Entity\Grupocomissaoregra get($primaryKey, $options = [])
 * @method \App\Model\Entity\Grupocomissaoregra newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Grupocomissaoregra[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Grupocomissaoregra|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Grupocomissaoregra|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Grupocomissaoregra patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Grupocomissaoregra[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Grupocomissaoregra findOrCreate($search, callable $callback = null, $options = [])
 */
class GrupocomissaoregraTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('grupocomissaoregra');
        $this->setDisplayField('grupocomissaoregraid');
        $this->setPrimaryKey('grupocomissaoregraid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('grupocomissaoregraid')
            ->allowEmpty('grupocomissaoregraid', 'create');

        $validator
            ->integer('grupoprodutofinanceiroid')
            ->requirePresence('grupoprodutofinanceiroid', 'create')
            ->notEmpty('grupoprodutofinanceiroid');

        $validator
            ->integer('regrarecebimentoid')
            ->requirePresence('regrarecebimentoid', 'create')
            ->notEmpty('regrarecebimentoid');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        return $validator;
    }
}
