<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Grupoproduto Model
 *
 * @method \App\Model\Entity\Grupoproduto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Grupoproduto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Grupoproduto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Grupoproduto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Grupoproduto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Grupoproduto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Grupoproduto findOrCreate($search, callable $callback = null, $options = [])
 */
class GrupoprodutoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('grupoproduto');
        $this->setDisplayField('grupoprodutoid');
        $this->setPrimaryKey('grupoprodutoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('grupoprodutoid')
            ->allowEmpty('grupoprodutoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('empresaid')
            ->requirePresence('empresaid', 'create')
            ->notEmpty('empresaid');

        $validator
            ->integer('coderp')
            ->allowEmpty('coderp');

        return $validator;
    }
}
