<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Grupoprodutofinanceiro Model
 *
 * @method \App\Model\Entity\Grupoprodutofinanceiro get($primaryKey, $options = [])
 * @method \App\Model\Entity\Grupoprodutofinanceiro newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Grupoprodutofinanceiro[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Grupoprodutofinanceiro|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Grupoprodutofinanceiro|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Grupoprodutofinanceiro patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Grupoprodutofinanceiro[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Grupoprodutofinanceiro findOrCreate($search, callable $callback = null, $options = [])
 */
class GrupoprodutofinanceiroTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('grupoprodutofinanceiro');
        $this->setDisplayField('grupoprodutofinanceiroid');
        $this->setPrimaryKey('grupoprodutofinanceiroid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('grupoprodutofinanceiroid')
            ->allowEmpty('grupoprodutofinanceiroid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        return $validator;
    }
}
