<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Hospital Model
 *
 * @method \App\Model\Entity\Hospital get($primaryKey, $options = [])
 * @method \App\Model\Entity\Hospital newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Hospital[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Hospital|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Hospital patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Hospital[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Hospital findOrCreate($search, callable $callback = null, $options = [])
 */
class HospitalTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('hospital');
        $this->setDisplayField('hospitalid');
        $this->setPrimaryKey('hospitalid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('hospitalid')
            ->allowEmpty('hospitalid', 'create');

        $validator
            ->scalar('ibge')
            ->maxLength('ibge', 10)
            ->requirePresence('ibge', 'create')
            ->notEmpty('ibge');

        $validator
            ->scalar('uf')
            ->maxLength('uf', 4)
            ->requirePresence('uf', 'create')
            ->notEmpty('uf');

        $validator
            ->scalar('municipio')
            ->maxLength('municipio', 100)
            ->requirePresence('municipio', 'create')
            ->notEmpty('municipio');

        $validator
            ->scalar('cnes')
            ->maxLength('cnes', 100)
            ->requirePresence('cnes', 'create')
            ->notEmpty('cnes');

        $validator
            ->scalar('nomefantasia')
            ->maxLength('nomefantasia', 255)
            ->requirePresence('nomefantasia', 'create')
            ->notEmpty('nomefantasia');

        $validator
            ->scalar('razaosocial')
            ->maxLength('razaosocial', 255)
            ->requirePresence('razaosocial', 'create')
            ->notEmpty('razaosocial');

        $validator
            ->scalar('cnpjproprio')
            ->maxLength('cnpjproprio', 20)
            ->requirePresence('cnpjproprio', 'create')
            ->notEmpty('cnpjproprio');

        $validator
            ->scalar('cnpjmantedora')
            ->maxLength('cnpjmantedora', 20)
            ->requirePresence('cnpjmantedora', 'create')
            ->notEmpty('cnpjmantedora');

        $validator
            ->scalar('tipogestao')
            ->maxLength('tipogestao', 10)
            ->requirePresence('tipogestao', 'create')
            ->notEmpty('tipogestao');

        $validator
            ->scalar('logradouro')
            ->maxLength('logradouro', 255)
            ->requirePresence('logradouro', 'create')
            ->notEmpty('logradouro');

        $validator
            ->integer('numero')
            ->requirePresence('numero', 'create')
            ->notEmpty('numero');

        $validator
            ->scalar('bairro')
            ->maxLength('bairro', 100)
            ->requirePresence('bairro', 'create')
            ->notEmpty('bairro');

        $validator
            ->scalar('cep')
            ->maxLength('cep', 15)
            ->requirePresence('cep', 'create')
            ->notEmpty('cep');

        $validator
            ->decimal('latitude')
            ->requirePresence('latitude', 'create')
            ->notEmpty('latitude');

        $validator
            ->decimal('longitude')
            ->requirePresence('longitude', 'create')
            ->notEmpty('longitude');

        $validator
            ->integer('codunimed')
            ->requirePresence('codunimed', 'create')
            ->notEmpty('codunimed');

        $validator
            ->boolean('ativo')
            ->requirePresence('ativo', 'create')
            ->notEmpty('ativo');

        return $validator;
    }
}
