<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Hospitalleitos Model
 *
 * @method \App\Model\Entity\Hospitalleito get($primaryKey, $options = [])
 * @method \App\Model\Entity\Hospitalleito newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Hospitalleito[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Hospitalleito|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Hospitalleito patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Hospitalleito[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Hospitalleito findOrCreate($search, callable $callback = null, $options = [])
 */
class HospitalleitosTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('hospitalleitos');
        $this->setDisplayField('hospitalleitosid');
        $this->setPrimaryKey('hospitalleitosid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('hospitalleitosid')
            ->allowEmpty('hospitalleitosid', 'create');

        $validator
            ->integer('hospitalid')
            ->requirePresence('hospitalid', 'create')
            ->notEmpty('hospitalid');

        $validator
            ->integer('enfermaria')
            ->requirePresence('enfermaria', 'create')
            ->notEmpty('enfermaria');

        $validator
            ->integer('enfadulto')
            ->requirePresence('enfadulto', 'create')
            ->notEmpty('enfadulto');

        $validator
            ->integer('enfpediatria')
            ->requirePresence('enfpediatria', 'create')
            ->notEmpty('enfpediatria');

        $validator
            ->integer('enfocup')
            ->requirePresence('enfocup', 'create')
            ->notEmpty('enfocup');

        $validator
            ->integer('enfcorona')
            ->requirePresence('enfcorona', 'create')
            ->notEmpty('enfcorona');

        $validator
            ->integer('uti')
            ->requirePresence('uti', 'create')
            ->notEmpty('uti');

        $validator
            ->integer('utiadulto')
            ->requirePresence('utiadulto', 'create')
            ->notEmpty('utiadulto');

        $validator
            ->integer('utipediatria')
            ->requirePresence('utipediatria', 'create')
            ->notEmpty('utipediatria');

        $validator
            ->integer('utiocup')
            ->requirePresence('utiocup', 'create')
            ->notEmpty('utiocup');

        $validator
            ->integer('uticorona')
            ->requirePresence('uticorona', 'create')
            ->notEmpty('uticorona');

        $validator
            ->integer('codunimed')
            ->requirePresence('codunimed', 'create')
            ->notEmpty('codunimed');

        return $validator;
    }
}
