<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * LogAcesso Model
 *
 * @method \App\Model\Entity\LogAcesso get($primaryKey, $options = [])
 * @method \App\Model\Entity\LogAcesso newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\LogAcesso[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\LogAcesso|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\LogAcesso patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\LogAcesso[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\LogAcesso findOrCreate($search, callable $callback = null, $options = [])
 */
class LogAcessoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('log_acesso');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('user')
            ->allowEmpty('user');

        $validator
            ->dateTime('data_hora')
            ->allowEmpty('data_hora');

        $validator
            ->scalar('ip')
            ->maxLength('ip', 80)
            ->allowEmpty('ip');

        $validator
            ->scalar('latitude')
            ->maxLength('latitude', 10)
            ->allowEmpty('latitude');

        $validator
            ->scalar('longitude')
            ->maxLength('longitude', 10)
            ->allowEmpty('longitude');

        $validator
            ->scalar('cidade')
            ->maxLength('cidade', 20)
            ->allowEmpty('cidade');

        $validator
            ->scalar('estado')
            ->maxLength('estado', 30)
            ->allowEmpty('estado');

        $validator
            ->scalar('pais')
            ->maxLength('pais', 20)
            ->allowEmpty('pais');

        $validator
            ->integer('validado')
            ->allowEmpty('validado');

        $validator
            ->scalar('user_digitado')
            ->maxLength('user_digitado', 255)
            ->allowEmpty('user_digitado');

        $validator
            ->scalar('pas_digitado')
            ->maxLength('pas_digitado', 255)
            ->allowEmpty('pas_digitado');

        $validator
            ->scalar('useragent')
            ->maxLength('useragent', 1000)
            ->allowEmpty('useragent');

        $validator
            ->scalar('url')
            ->maxLength('url', 1000)
            ->allowEmpty('url');

        $validator
            ->scalar('request')
            ->maxLength('request', 8000)
            ->allowEmpty('request');

        return $validator;
    }
}
