<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * LogEdicao Model
 *
 * @method \App\Model\Entity\LogEdicao get($primaryKey, $options = [])
 * @method \App\Model\Entity\LogEdicao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\LogEdicao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\LogEdicao|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\LogEdicao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\LogEdicao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\LogEdicao findOrCreate($search, callable $callback = null, $options = [])
 */
class LogEdicaoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('log_edicao');
        $this->setDisplayField('log_edicaoid');
        $this->setPrimaryKey('log_edicaoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('log_edicaoid')
            ->allowEmpty('log_edicaoid', 'create');

        $validator
            ->integer('atendimentoid')
            ->requirePresence('atendimentoid', 'create')
            ->notEmpty('atendimentoid');

        $validator
            ->integer('usuarioid')
            ->requirePresence('usuarioid', 'create')
            ->notEmpty('usuarioid');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        $validator
            ->dateTime('data_edicao')
            ->requirePresence('data_edicao', 'create')
            ->notEmpty('data_edicao');

        return $validator;
    }
}
