<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Meta Model
 *
 * @method \App\Model\Entity\Metum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Metum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Metum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Metum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Metum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Metum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Metum findOrCreate($search, callable $callback = null, $options = [])
 */
class MetaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('meta');
        $this->setDisplayField('idmeta');
        $this->setPrimaryKey('idmeta');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idmeta')
            ->allowEmpty('idmeta', 'create');

        $validator
            ->integer('idgrupo')
            ->allowEmpty('idgrupo');

        $validator
            ->scalar('data_inicio')
            ->maxLength('data_inicio', 20)
            ->allowEmpty('data_inicio');

        $validator
            ->scalar('data_fim')
            ->maxLength('data_fim', 20)
            ->allowEmpty('data_fim');

        $validator
            ->scalar('ano')
            ->maxLength('ano', 20)
            ->allowEmpty('ano');

        $validator
            ->scalar('mes')
            ->maxLength('mes', 20)
            ->allowEmpty('mes');

        $validator
            ->integer('usuario_criacao')
            ->allowEmpty('usuario_criacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 2000)
            ->allowEmpty('observacao');

        return $validator;
    }
}
