<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Metasproducao Model
 *
 * @method \App\Model\Entity\Metasproducao get($primaryKey, $options = [])
 * @method \App\Model\Entity\Metasproducao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Metasproducao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Metasproducao|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Metasproducao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Metasproducao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Metasproducao findOrCreate($search, callable $callback = null, $options = [])
 */
class MetasproducaoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('metasproducao');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->scalar('codproduto')
            ->maxLength('codproduto', 100)
            ->allowEmpty('codproduto');

        $validator
            ->scalar('produto')
            ->maxLength('produto', 100)
            ->allowEmpty('produto');

        $validator
            ->integer('ano')
            ->allowEmpty('ano');

        $validator
            ->decimal('janeiro')
            ->allowEmpty('janeiro');

        $validator
            ->decimal('fevereiro')
            ->allowEmpty('fevereiro');

        $validator
            ->decimal('marco')
            ->allowEmpty('marco');

        $validator
            ->decimal('abril')
            ->allowEmpty('abril');

        $validator
            ->decimal('maio')
            ->allowEmpty('maio');

        $validator
            ->decimal('junho')
            ->allowEmpty('junho');

        $validator
            ->decimal('julho')
            ->allowEmpty('julho');

        $validator
            ->decimal('agosto')
            ->allowEmpty('agosto');

        $validator
            ->decimal('setembro')
            ->allowEmpty('setembro');

        $validator
            ->decimal('outubro')
            ->allowEmpty('outubro');

        $validator
            ->decimal('novembro')
            ->allowEmpty('novembro');

        $validator
            ->decimal('dezembro')
            ->allowEmpty('dezembro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        return $validator;
    }
}
