<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Metasvendedores Model
 *
 * @method \App\Model\Entity\Metasvendedore get($primaryKey, $options = [])
 * @method \App\Model\Entity\Metasvendedore newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Metasvendedore[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Metasvendedore|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Metasvendedore patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Metasvendedore[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Metasvendedore findOrCreate($search, callable $callback = null, $options = [])
 */
class MetasvendedoresTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('metasvendedores');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->scalar('coderp')
            ->maxLength('coderp', 10)
            ->allowEmpty('coderp');

        $validator
            ->scalar('cpf')
            ->maxLength('cpf', 20)
            ->allowEmpty('cpf');

        $validator
            ->scalar('vendedor')
            ->maxLength('vendedor', 255)
            ->allowEmpty('vendedor');

        $validator
            ->integer('semana')
            ->allowEmpty('semana');

        $validator
            ->integer('mes')
            ->allowEmpty('mes');

        $validator
            ->integer('ano')
            ->allowEmpty('ano');

        $validator
            ->decimal('meta')
            ->allowEmpty('meta');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
