<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Metavendedor Model
 *
 * @method \App\Model\Entity\Metavendedor get($primaryKey, $options = [])
 * @method \App\Model\Entity\Metavendedor newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Metavendedor[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Metavendedor|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Metavendedor patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Metavendedor[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Metavendedor findOrCreate($search, callable $callback = null, $options = [])
 */
class MetavendedorTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('metavendedor');
        $this->setDisplayField('idmetavendedor');
        $this->setPrimaryKey('idmetavendedor');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idmetavendedor')
            ->allowEmpty('idmetavendedor', 'create');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('idsupervisor')
            ->allowEmpty('idsupervisor');

        $validator
            ->scalar('data_inicio')
            ->maxLength('data_inicio', 20)
            ->allowEmpty('data_inicio');

        $validator
            ->scalar('data_fim')
            ->maxLength('data_fim', 20)
            ->allowEmpty('data_fim');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->integer('idvendedor')
            ->allowEmpty('idvendedor');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 2000)
            ->allowEmpty('observacao');

        $validator
            ->integer('ano')
            ->allowEmpty('ano');

        $validator
            ->integer('mes')
            ->allowEmpty('mes');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('usuario_criacao')
            ->maxLength('usuario_criacao', 20)
            ->allowEmpty('usuario_criacao');

        return $validator;
    }
}
