<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Movimento Model
 *
 * @method \App\Model\Entity\Movimento get($primaryKey, $options = [])
 * @method \App\Model\Entity\Movimento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Movimento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Movimento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Movimento|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Movimento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Movimento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Movimento findOrCreate($search, callable $callback = null, $options = [])
 */
class MovimentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('movimento');
        $this->setDisplayField('movimentoid');
        $this->setPrimaryKey('movimentoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('movimentoid')
            ->allowEmpty('movimentoid', 'create');

        $validator
            ->integer('movimentoidpai')
            ->allowEmpty('movimentoidpai');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 20)
            ->allowEmpty('tipo');

        $validator
            ->scalar('status')
            ->maxLength('status', 20)
            ->allowEmpty('status');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->integer('pessoaidvendedor')
            ->allowEmpty('pessoaidvendedor');

        $validator
            ->numeric('valor')
            ->allowEmpty('valor');

        $validator
            ->numeric('valorbruto')
            ->allowEmpty('valorbruto');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 800)
            ->allowEmpty('observacao');

        $validator
            ->dateTime('dataoperacao')
            ->allowEmpty('dataoperacao');

        $validator
            ->integer('usuariooperacao')
            ->allowEmpty('usuariooperacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
