<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Movimentoitem Model
 *
 * @method \App\Model\Entity\Movimentoitem get($primaryKey, $options = [])
 * @method \App\Model\Entity\Movimentoitem newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Movimentoitem[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Movimentoitem|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Movimentoitem|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Movimentoitem patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Movimentoitem[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Movimentoitem findOrCreate($search, callable $callback = null, $options = [])
 */
class MovimentoitemTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('movimentoitem');
        $this->setDisplayField('movimentoitemid');
        $this->setPrimaryKey('movimentoitemid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('movimentoitemid')
            ->allowEmpty('movimentoitemid', 'create');

        $validator
            ->integer('movimentoid')
            ->requirePresence('movimentoid', 'create')
            ->notEmpty('movimentoid');

        $validator
            ->integer('produtoid')
            ->allowEmpty('produtoid');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->numeric('valor')
            ->allowEmpty('valor');

        $validator
            ->numeric('valorbruto')
            ->allowEmpty('valorbruto');

        $validator
            ->integer('quantidade')
            ->allowEmpty('quantidade');

        $validator
            ->numeric('percdesconto')
            ->allowEmpty('percdesconto');

        $validator
            ->dateTime('dataoperacao')
            ->allowEmpty('dataoperacao');

        $validator
            ->integer('usuariooperacao')
            ->allowEmpty('usuariooperacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
