<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Origemlead Model
 *
 * @method \App\Model\Entity\Origemlead get($primaryKey, $options = [])
 * @method \App\Model\Entity\Origemlead newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Origemlead[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Origemlead|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Origemlead patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Origemlead[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Origemlead findOrCreate($search, callable $callback = null, $options = [])
 */
class OrigemleadTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('origemlead');
        $this->setDisplayField('origemleadid');
        $this->setPrimaryKey('origemleadid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('origemleadid')
            ->allowEmpty('origemleadid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('ordem')
            ->allowEmpty('ordem');

        return $validator;
    }
}
