<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PacienteGruporisco Model
 *
 * @method \App\Model\Entity\PacienteGruporisco get($primaryKey, $options = [])
 * @method \App\Model\Entity\PacienteGruporisco newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\PacienteGruporisco[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PacienteGruporisco|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\PacienteGruporisco patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\PacienteGruporisco[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\PacienteGruporisco findOrCreate($search, callable $callback = null, $options = [])
 */
class PacienteGruporiscoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('paciente_gruporisco');
        $this->setDisplayField('paciente_gruporiscoid');
        $this->setPrimaryKey('paciente_gruporiscoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('paciente_gruporiscoid')
            ->allowEmpty('paciente_gruporiscoid', 'create');

        $validator
            ->integer('entradapacientesid')
            ->requirePresence('entradapacientesid', 'create')
            ->notEmpty('entradapacientesid');

        $validator
            ->scalar('gruporisco')
            ->maxLength('gruporisco', 255)
            ->requirePresence('gruporisco', 'create')
            ->notEmpty('gruporisco');

        return $validator;
    }
}
