<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PacientehomecareGruporisco Model
 *
 * @method \App\Model\Entity\PacientehomecareGruporisco get($primaryKey, $options = [])
 * @method \App\Model\Entity\PacientehomecareGruporisco newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\PacientehomecareGruporisco[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PacientehomecareGruporisco|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\PacientehomecareGruporisco patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\PacientehomecareGruporisco[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\PacientehomecareGruporisco findOrCreate($search, callable $callback = null, $options = [])
 */
class PacientehomecareGruporiscoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('pacientehomecare_gruporisco');
        $this->setDisplayField('pacientehomecare_gruporiscoid');
        $this->setPrimaryKey('pacientehomecare_gruporiscoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('pacientehomecare_gruporiscoid')
            ->allowEmpty('pacientehomecare_gruporiscoid', 'create');

        $validator
            ->scalar('gruporisco')
            ->maxLength('gruporisco', 255)
            ->requirePresence('gruporisco', 'create')
            ->notEmpty('gruporisco');

        $validator
            ->integer('pacientes_homecareid')
            ->requirePresence('pacientes_homecareid', 'create')
            ->notEmpty('pacientes_homecareid');

        return $validator;
    }
}
