<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PacientesHomecare Model
 *
 * @method \App\Model\Entity\PacientesHomecare get($primaryKey, $options = [])
 * @method \App\Model\Entity\PacientesHomecare newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\PacientesHomecare[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PacientesHomecare|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\PacientesHomecare patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\PacientesHomecare[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\PacientesHomecare findOrCreate($search, callable $callback = null, $options = [])
 */
class PacientesHomecareTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('pacientes_homecare');
        $this->setDisplayField('pacientes_homecareid');
        $this->setPrimaryKey('pacientes_homecareid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('pacientes_homecareid')
            ->allowEmpty('pacientes_homecareid', 'create');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 20)
            ->allowEmpty('tipo');

        $validator
            ->scalar('sexo')
            ->maxLength('sexo', 20)
            ->allowEmpty('sexo');

        $validator
            ->integer('idade')
            ->allowEmpty('idade');

        $validator
            ->scalar('gruporisco')
            ->maxLength('gruporisco', 50)
            ->allowEmpty('gruporisco');

        $validator
            ->integer('qtdpessoas')
            ->allowEmpty('qtdpessoas');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 255)
            ->allowEmpty('observacao');

        $validator
            ->integer('usuariocadastro')
            ->allowEmpty('usuariocadastro');

        $validator
            ->scalar('usuariocadastronome')
            ->maxLength('usuariocadastronome', 50)
            ->allowEmpty('usuariocadastronome');

        $validator
            ->dateTime('datacadastro')
            ->requirePresence('datacadastro', 'create')
            ->notEmpty('datacadastro');

        $validator
            ->integer('codunimed')
            ->allowEmpty('codunimed');

        $validator
            ->scalar('carteiracpf')
            ->maxLength('carteiracpf', 50)
            ->requirePresence('carteiracpf', 'create')
            ->notEmpty('carteiracpf');

        $validator
            ->date('data_nascimento')
            ->allowEmpty('data_nascimento');

        $validator
            ->scalar('local')
            ->maxLength('local', 50)
            ->allowEmpty('local');

        $validator
            ->boolean('testecolhido')
            ->requirePresence('testecolhido', 'create')
            ->notEmpty('testecolhido');

        $validator
            ->boolean('ventilacao')
            ->requirePresence('ventilacao', 'create')
            ->notEmpty('ventilacao');

        $validator
            ->boolean('alta')
            ->requirePresence('alta', 'create')
            ->notEmpty('alta');

        $validator
            ->scalar('codigoteste')
            ->maxLength('codigoteste', 255)
            ->allowEmpty('codigoteste');

        $validator
            ->scalar('ultimotratamento')
            ->maxLength('ultimotratamento', 255)
            ->allowEmpty('ultimotratamento');

        $validator
            ->date('data_ultimotratamento')
            ->allowEmpty('data_ultimotratamento');

        $validator
            ->boolean('obito')
            ->requirePresence('obito', 'create')
            ->notEmpty('obito');

        $validator
            ->scalar('tipoprograma')
            ->maxLength('tipoprograma', 255)
            ->allowEmpty('tipoprograma');

        return $validator;
    }
}
