<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Parametro Model
 *
 * @method \App\Model\Entity\Parametro get($primaryKey, $options = [])
 * @method \App\Model\Entity\Parametro newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Parametro[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Parametro|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parametro patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Parametro[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Parametro findOrCreate($search, callable $callback = null, $options = [])
 */
class ParametroTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('parametro');
        $this->setDisplayField('idparametro');
        $this->setPrimaryKey('idparametro');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idparametro')
            ->allowEmpty('idparametro', 'create');

        $validator
            ->scalar('chave')
            ->maxLength('chave', 255)
            ->requirePresence('chave', 'create')
            ->notEmpty('chave');

        $validator
            ->scalar('valor')
            ->maxLength('valor', 255)
            ->requirePresence('valor', 'create')
            ->notEmpty('valor');

        $validator
            ->boolean('ativo')
            ->requirePresence('ativo', 'create')
            ->notEmpty('ativo');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->integer('ordem')
            ->allowEmpty('ordem');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        return $validator;
    }
}
