<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Parcela Model
 *
 * @method \App\Model\Entity\Parcela get($primaryKey, $options = [])
 * @method \App\Model\Entity\Parcela newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Parcela[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Parcela|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcela|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcela patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Parcela[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Parcela findOrCreate($search, callable $callback = null, $options = [])
 */
class ParcelaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('parcela');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('parcelaid')
            ->allowEmpty('parcelaid');

        $validator
            ->integer('produtoid')
            ->allowEmpty('produtoid');

        $validator
            ->decimal('comissaoperc')
            ->allowEmpty('comissaoperc');

        $validator
            ->decimal('comissaovalor')
            ->allowEmpty('comissaovalor');

        $validator
            ->decimal('bonusperc')
            ->allowEmpty('bonusperc');

        $validator
            ->decimal('bonusvalor')
            ->allowEmpty('bonusvalor');

        $validator
            ->decimal('totalperc')
            ->allowEmpty('totalperc');

        $validator
            ->decimal('totalvalor')
            ->allowEmpty('totalvalor');

        $validator
            ->decimal('corretora')
            ->allowEmpty('corretora');

        $validator
            ->decimal('franquia')
            ->allowEmpty('franquia');

        $validator
            ->decimal('franchising')
            ->allowEmpty('franchising');

        $validator
            ->decimal('total')
            ->allowEmpty('total');

        return $validator;
    }
}
