<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Parcelaproduto Model
 *
 * @method \App\Model\Entity\Parcelaproduto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Parcelaproduto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Parcelaproduto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Parcelaproduto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcelaproduto|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcelaproduto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Parcelaproduto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Parcelaproduto findOrCreate($search, callable $callback = null, $options = [])
 */
class ParcelaprodutoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('parcelaproduto');
        $this->setDisplayField('parcelaprodutoid');
        $this->setPrimaryKey('parcelaprodutoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('parcelaprodutoid')
            ->allowEmpty('parcelaprodutoid', 'create');

        $validator
            ->integer('produtoid')
            ->requirePresence('produtoid', 'create')
            ->notEmpty('produtoid');

        $validator
            ->integer('numero')
            ->requirePresence('numero', 'create')
            ->notEmpty('numero');

        $validator
            ->decimal('percentual')
            ->requirePresence('percentual', 'create')
            ->notEmpty('percentual');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('qtdparcela')
            ->requirePresence('qtdparcela', 'create')
            ->notEmpty('qtdparcela');

        return $validator;
    }
}
