<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Parcelarecebimento Model
 *
 * @method \App\Model\Entity\Parcelarecebimento get($primaryKey, $options = [])
 * @method \App\Model\Entity\Parcelarecebimento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Parcelarecebimento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Parcelarecebimento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcelarecebimento|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcelarecebimento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Parcelarecebimento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Parcelarecebimento findOrCreate($search, callable $callback = null, $options = [])
 */
class ParcelarecebimentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('parcelarecebimento');
        $this->setDisplayField('parcelarecebimentoid');
        $this->setPrimaryKey('parcelarecebimentoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('parcelarecebimentoid')
            ->allowEmpty('parcelarecebimentoid', 'create');

        $validator
            ->integer('numero')
            ->requirePresence('numero', 'create')
            ->notEmpty('numero');

        $validator
            ->integer('regrarecebimentoid')
            ->requirePresence('regrarecebimentoid', 'create')
            ->notEmpty('regrarecebimentoid');

        $validator
            ->decimal('percentual')
            ->requirePresence('percentual', 'create')
            ->notEmpty('percentual');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        return $validator;
    }
}
