<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Parcelaregra Model
 *
 * @method \App\Model\Entity\Parcelaregra get($primaryKey, $options = [])
 * @method \App\Model\Entity\Parcelaregra newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Parcelaregra[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Parcelaregra|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcelaregra|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Parcelaregra patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Parcelaregra[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Parcelaregra findOrCreate($search, callable $callback = null, $options = [])
 */
class ParcelaregraTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('parcelaregra');
        $this->setDisplayField('parcelaregraid');
        $this->setPrimaryKey('parcelaregraid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('parcelaregraid')
            ->allowEmpty('parcelaregraid', 'create');

        $validator
            ->integer('regraprodutoid')
            ->requirePresence('regraprodutoid', 'create')
            ->notEmpty('regraprodutoid');

        $validator
            ->integer('numero')
            ->requirePresence('numero', 'create')
            ->notEmpty('numero');

        $validator
            ->decimal('percentualcorretora')
            ->requirePresence('percentualcorretora', 'create')
            ->notEmpty('percentualcorretora');

        $validator
            ->decimal('percentualfranquia')
            ->requirePresence('percentualfranquia', 'create')
            ->notEmpty('percentualfranquia');

        $validator
            ->decimal('percentualfranchising')
            ->requirePresence('percentualfranchising', 'create')
            ->notEmpty('percentualfranchising');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        return $validator;
    }
}
