<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PerfilCrm Model
 *
 * @method \App\Model\Entity\PerfilCrm get($primaryKey, $options = [])
 * @method \App\Model\Entity\PerfilCrm newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\PerfilCrm[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PerfilCrm|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\PerfilCrm patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\PerfilCrm[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\PerfilCrm findOrCreate($search, callable $callback = null, $options = [])
 */
class PerfilCrmTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('perfil_crm');
        $this->setDisplayField('idperfil_crm');
        $this->setPrimaryKey('idperfil_crm');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idperfil_crm')
            ->allowEmpty('idperfil_crm', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->integer('idempresa_crm')
            ->allowEmpty('idempresa_crm');

        $validator
            ->integer('ordem')
            ->allowEmpty('ordem');

        $validator
            ->scalar('pagina_inicial')
            ->maxLength('pagina_inicial', 255)
            ->allowEmpty('pagina_inicial');

        return $validator;
    }
}
