<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * PerfilusuarioCrm Model
 *
 * @method \App\Model\Entity\PerfilusuarioCrm get($primaryKey, $options = [])
 * @method \App\Model\Entity\PerfilusuarioCrm newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\PerfilusuarioCrm[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\PerfilusuarioCrm|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\PerfilusuarioCrm patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\PerfilusuarioCrm[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\PerfilusuarioCrm findOrCreate($search, callable $callback = null, $options = [])
 */
class PerfilusuarioCrmTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('perfilusuario_crm');
        $this->setDisplayField('perfilusuarioid');
        $this->setPrimaryKey('perfilusuarioid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('perfilusuarioid')
            ->allowEmpty('perfilusuarioid', 'create');

        $validator
            ->integer('idperfil_crm')
            ->allowEmpty('idperfil_crm');

        $validator
            ->integer('usuarioid')
            ->allowEmpty('usuarioid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('idempresa_crm')
            ->allowEmpty('idempresa_crm');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->scalar('pagina_inicial')
            ->maxLength('pagina_inicial', 255)
            ->allowEmpty('pagina_inicial');

        return $validator;
    }
}
