<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Perfilusuario Model
 *
 * @method \App\Model\Entity\Perfilusuario get($primaryKey, $options = [])
 * @method \App\Model\Entity\Perfilusuario newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Perfilusuario[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Perfilusuario|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Perfilusuario|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Perfilusuario patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Perfilusuario[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Perfilusuario findOrCreate($search, callable $callback = null, $options = [])
 */
class PerfilusuarioTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('perfilusuario');
        $this->setDisplayField('perfilusuarioid');
        $this->setPrimaryKey('perfilusuarioid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('perfilusuarioid')
            ->allowEmpty('perfilusuarioid', 'create');

        $validator
            ->integer('perfilid')
            ->allowEmpty('perfilid');

        $validator
            ->integer('usuarioid')
            ->allowEmpty('usuarioid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        return $validator;
    }
}
