<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Pessoa Model
 *
 * @method \App\Model\Entity\Pessoa get($primaryKey, $options = [])
 * @method \App\Model\Entity\Pessoa newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Pessoa[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Pessoa|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Pessoa patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Pessoa[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Pessoa findOrCreate($search, callable $callback = null, $options = [])
 */
class PessoaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('pessoa');
        $this->setDisplayField('pessoaid');
        $this->setPrimaryKey('pessoaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid', 'create');

        $validator
            ->scalar('telefone')
            ->maxLength('telefone', 20)
            ->allowEmpty('telefone');

        $validator
            ->date('data_nascimento')
            ->allowEmpty('data_nascimento');

        $validator
            ->scalar('documento')
            ->maxLength('documento', 30)
            ->allowEmpty('documento');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('sexo')
            ->maxLength('sexo', 20)
            ->allowEmpty('sexo');

        $validator
            ->scalar('cidade')
            ->maxLength('cidade', 50)
            ->allowEmpty('cidade');

        $validator
            ->scalar('bairro')
            ->maxLength('bairro', 50)
            ->allowEmpty('bairro');

        $validator
            ->scalar('logradouro')
            ->maxLength('logradouro', 255)
            ->allowEmpty('logradouro');

        $validator
            ->boolean('gestante')
            ->allowEmpty('gestante');

        $validator
            ->integer('tempogestacao')
            ->allowEmpty('tempogestacao');

        $validator
            ->integer('atendimentoid')
            ->allowEmpty('atendimentoid');

        $validator
            ->scalar('cpfcnpj')
            ->maxLength('cpfcnpj', 255)
            ->allowEmpty('cpfcnpj');

        $validator
            ->email('email')
            ->allowEmpty('email');

        $validator
            ->scalar('estado')
            ->maxLength('estado', 255)
            ->allowEmpty('estado');

        $validator
            ->scalar('pais')
            ->maxLength('pais', 255)
            ->allowEmpty('pais');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->scalar('cpfmae')
            ->maxLength('cpfmae', 255)
            ->allowEmpty('cpfmae');

        $validator
            ->scalar('nomemae')
            ->maxLength('nomemae', 255)
            ->allowEmpty('nomemae');

        $validator
            ->scalar('estadocivil')
            ->maxLength('estadocivil', 255)
            ->allowEmpty('estadocivil');

        $validator
            ->scalar('segmento')
            ->maxLength('segmento', 255)
            ->allowEmpty('segmento');

        $validator
            ->date('datanascimento')
            ->allowEmpty('datanascimento');

        $validator
            ->scalar('razaosocial')
            ->maxLength('razaosocial', 255)
            ->allowEmpty('razaosocial');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->scalar('tipopessoa')
            ->maxLength('tipopessoa', 20)
            ->allowEmpty('tipopessoa');

        $validator
            ->scalar('cargo')
            ->maxLength('cargo', 255)
            ->allowEmpty('cargo');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['email']));

        return $rules;
    }
}
