<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Planoconta Model
 *
 * @method \App\Model\Entity\Planocontum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Planocontum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Planocontum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Planocontum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Planocontum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Planocontum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Planocontum findOrCreate($search, callable $callback = null, $options = [])
 */
class PlanocontaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('planoconta');
        $this->setDisplayField('planocontaid');
        $this->setPrimaryKey('planocontaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('planocontaid')
            ->allowEmpty('planocontaid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 60)
            ->allowEmpty('tipo');

        $validator
            ->scalar('ordem')
            ->maxLength('ordem', 20)
            ->allowEmpty('ordem');

        $validator
            ->dateTime('dataoperacao')
            ->allowEmpty('dataoperacao');

        $validator
            ->integer('usuariooperacao')
            ->allowEmpty('usuariooperacao');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
