<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ProdutoCrm Model
 *
 * @method \App\Model\Entity\ProdutoCrm get($primaryKey, $options = [])
 * @method \App\Model\Entity\ProdutoCrm newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\ProdutoCrm[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ProdutoCrm|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\ProdutoCrm patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\ProdutoCrm[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\ProdutoCrm findOrCreate($search, callable $callback = null, $options = [])
 */
class ProdutoCrmTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('produto_crm');
        $this->setDisplayField('produtoid');
        $this->setPrimaryKey('produtoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('produtoid')
            ->allowEmpty('produtoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->scalar('valor')
            ->maxLength('valor', 20)
            ->allowEmpty('valor');

        $validator
            ->integer('grupoid')
            ->allowEmpty('grupoid');

        $validator
            ->integer('subgrupoid')
            ->allowEmpty('subgrupoid');

        $validator
            ->scalar('fabricante')
            ->maxLength('fabricante', 255)
            ->allowEmpty('fabricante');

        $validator
            ->scalar('unidade')
            ->maxLength('unidade', 70)
            ->allowEmpty('unidade');

        $validator
            ->integer('sdofisico')
            ->allowEmpty('sdofisico');

        $validator
            ->integer('coderp')
            ->allowEmpty('coderp');

        return $validator;
    }
}
