<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Produtogrupoprodutofinanceiro Model
 *
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro get($primaryKey, $options = [])
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Produtogrupoprodutofinanceiro findOrCreate($search, callable $callback = null, $options = [])
 */
class ProdutogrupoprodutofinanceiroTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('produtogrupoprodutofinanceiro');
        $this->setDisplayField('produtogrupoprodutofinanceiroid');
        $this->setPrimaryKey('produtogrupoprodutofinanceiroid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('produtogrupoprodutofinanceiroid')
            ->allowEmpty('produtogrupoprodutofinanceiroid', 'create');

        $validator
            ->integer('grupoprodutofinanceiroid')
            ->requirePresence('grupoprodutofinanceiroid', 'create')
            ->notEmpty('grupoprodutofinanceiroid');

        $validator
            ->integer('estipulanteid')
            ->requirePresence('estipulanteid', 'create')
            ->notEmpty('estipulanteid');

        $validator
            ->integer('operadoraid')
            ->requirePresence('operadoraid', 'create')
            ->notEmpty('operadoraid');

        $validator
            ->scalar('uf')
            ->maxLength('uf', 4)
            ->requirePresence('uf', 'create')
            ->notEmpty('uf');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        return $validator;
    }
}
