<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Produtointeresse Model
 *
 * @method \App\Model\Entity\Produtointeresse get($primaryKey, $options = [])
 * @method \App\Model\Entity\Produtointeresse newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Produtointeresse[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Produtointeresse|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Produtointeresse patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Produtointeresse[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Produtointeresse findOrCreate($search, callable $callback = null, $options = [])
 */
class ProdutointeresseTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('produtointeresse');
        $this->setDisplayField('produtointeresseid');
        $this->setPrimaryKey('produtointeresseid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('produtointeresseid')
            ->allowEmpty('produtointeresseid', 'create');

        $validator
            ->integer('produtoid')
            ->allowEmpty('produtoid');

        $validator
            ->integer('clienteid')
            ->allowEmpty('clienteid');

        $validator
            ->integer('contatoid')
            ->allowEmpty('contatoid');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->decimal('valor')
            ->allowEmpty('valor');

        $validator
            ->integer('quantidade')
            ->allowEmpty('quantidade');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
