<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Projeto Model
 *
 * @method \App\Model\Entity\Projeto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Projeto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Projeto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Projeto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Projeto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Projeto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Projeto findOrCreate($search, callable $callback = null, $options = [])
 */
class ProjetoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('projeto');
        $this->setDisplayField('idprojeto');
        $this->setPrimaryKey('idprojeto');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idprojeto')
            ->allowEmpty('idprojeto', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 8000)
            ->allowEmpty('descricao');

        $validator
            ->integer('idusuariolider')
            ->allowEmpty('idusuariolider');

        $validator
            ->scalar('patrocinador')
            ->maxLength('patrocinador', 255)
            ->allowEmpty('patrocinador');

        $validator
            ->date('data_inicio')
            ->allowEmpty('data_inicio');

        $validator
            ->date('data_fim')
            ->allowEmpty('data_fim');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 255)
            ->allowEmpty('tipo');

        $validator
            ->scalar('status')
            ->maxLength('status', 255)
            ->allowEmpty('status');

        $validator
            ->scalar('fase')
            ->maxLength('fase', 255)
            ->allowEmpty('fase');

        $validator
            ->scalar('subfase')
            ->maxLength('subfase', 255)
            ->allowEmpty('subfase');

        $validator
            ->scalar('custo')
            ->maxLength('custo', 20)
            ->allowEmpty('custo');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
