<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Projetomembro Model
 *
 * @method \App\Model\Entity\Projetomembro get($primaryKey, $options = [])
 * @method \App\Model\Entity\Projetomembro newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Projetomembro[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Projetomembro|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Projetomembro patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Projetomembro[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Projetomembro findOrCreate($search, callable $callback = null, $options = [])
 */
class ProjetomembroTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('projetomembro');
        $this->setDisplayField('idprojetomembro');
        $this->setPrimaryKey('idprojetomembro');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idprojetomembro')
            ->allowEmpty('idprojetomembro', 'create');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->scalar('papel')
            ->maxLength('papel', 255)
            ->allowEmpty('papel');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
