<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Projetoobs Model
 *
 * @method \App\Model\Entity\Projetoob get($primaryKey, $options = [])
 * @method \App\Model\Entity\Projetoob newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Projetoob[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Projetoob|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Projetoob patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Projetoob[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Projetoob findOrCreate($search, callable $callback = null, $options = [])
 */
class ProjetoobsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('projetoobs');
        $this->setDisplayField('idprojetoobs');
        $this->setPrimaryKey('idprojetoobs');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idprojetoobs')
            ->allowEmpty('idprojetoobs', 'create');

        $validator
            ->integer('idprojeto')
            ->allowEmpty('idprojeto');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 8000)
            ->allowEmpty('observacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('log')
            ->allowEmpty('log');

        return $validator;
    }
}
