<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Prontuarioatendimento Model
 *
 * @method \App\Model\Entity\Prontuarioatendimento get($primaryKey, $options = [])
 * @method \App\Model\Entity\Prontuarioatendimento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Prontuarioatendimento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Prontuarioatendimento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Prontuarioatendimento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Prontuarioatendimento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Prontuarioatendimento findOrCreate($search, callable $callback = null, $options = [])
 */
class ProntuarioatendimentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('prontuarioatendimento');
        $this->setDisplayField('prontuarioatendimentoid');
        $this->setPrimaryKey('prontuarioatendimentoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('prontuarioatendimentoid')
            ->allowEmpty('prontuarioatendimentoid', 'create');

        $validator
            ->scalar('carteiracpf')
            ->maxLength('carteiracpf', 30)
            ->requirePresence('carteiracpf', 'create')
            ->notEmpty('carteiracpf');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 50)
            ->allowEmpty('tipo');

        $validator
            ->scalar('local')
            ->maxLength('local', 50)
            ->allowEmpty('local');

        $validator
            ->boolean('ventilacao')
            ->requirePresence('ventilacao', 'create')
            ->notEmpty('ventilacao');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 50)
            ->allowEmpty('nome');

        $validator
            ->scalar('sexo')
            ->maxLength('sexo', 20)
            ->allowEmpty('sexo');

        $validator
            ->date('data_nascimento')
            ->allowEmpty('data_nascimento');

        $validator
            ->boolean('testecolhido')
            ->requirePresence('testecolhido', 'create')
            ->notEmpty('testecolhido');

        $validator
            ->scalar('codigoteste')
            ->maxLength('codigoteste', 50)
            ->allowEmpty('codigoteste');

        $validator
            ->integer('entradapacienteid_gruporisco')
            ->allowEmpty('entradapacienteid_gruporisco');

        $validator
            ->dateTime('data_entrada')
            ->requirePresence('data_entrada', 'create')
            ->notEmpty('data_entrada');

        $validator
            ->dateTime('data_saida')
            ->allowEmpty('data_saida');

        $validator
            ->boolean('alta')
            ->allowEmpty('alta');

        $validator
            ->dateTime('data_alta')
            ->allowEmpty('data_alta');

        $validator
            ->boolean('obito')
            ->allowEmpty('obito');

        $validator
            ->dateTime('data_obito')
            ->allowEmpty('data_obito');

        $validator
            ->integer('hospitalid')
            ->requirePresence('hospitalid', 'create')
            ->notEmpty('hospitalid');

        $validator
            ->boolean('fimprontuario')
            ->requirePresence('fimprontuario', 'create')
            ->notEmpty('fimprontuario');

        $validator
            ->integer('usuarioidcadastro')
            ->requirePresence('usuarioidcadastro', 'create')
            ->notEmpty('usuarioidcadastro');

        $validator
            ->scalar('usuarionomecadastro')
            ->maxLength('usuarionomecadastro', 50)
            ->allowEmpty('usuarionomecadastro');

        return $validator;
    }
}
